/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.php.debug.ui.phpini;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.php.epl.PHPEplPlugin;
import com.aptana.php.debug.PHPDebugPlugin;
import com.aptana.php.debug.ui.phpini.INIFileSection;
import com.aptana.php.debug.ui.phpini.Messages;
import com.aptana.php.debug.ui.phpini.NewPHPIniEntryDialog;
import com.aptana.php.debug.ui.phpini.NewPHPIniSectionDialog;
import com.aptana.php.debug.ui.phpini.PHPIniContentProvider;
import com.aptana.php.debug.ui.phpini.PHPIniEntry;
import com.aptana.php.debug.ui.phpini.PHPIniValidator;
import com.aptana.ui.UIPlugin;
import com.aptana.ui.util.SWTUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class PHPIniEditor {
    private static final String DELETE_ICON = "/icons/delete.gif";
    private static final String ADD_ICON = "/icons/add.gif";
    private static final String ADD_SECTION_ICON_PATH = "/icons/full/obj16/add_section.gif";
    private static final Image COMMENT_ICON = SWTUtils.getImage((AbstractUIPlugin)PHPEplPlugin.getDefault(), (String)"/icons/full/obj16/comment.gif");
    private static final Image UNCOMMENT_ICON = SWTUtils.getImage((AbstractUIPlugin)PHPEplPlugin.getDefault(), (String)"/icons/full/obj16/uncomment.gif");
    private static final Image VALIDATE_ICON = SWTUtils.getImage((AbstractUIPlugin)PHPEplPlugin.getDefault(), (String)"/icons/full/obj16/validate.gif");
    private static final String VALIDATION_OK_TOOLTIP = "<form><p><span font=\"header\">{0}:</span></p><BR/><li style=\"text\" bindent=\"5\" indent=\"5\">The extension is functional</li></form>";
    private static final String VALIDATION_ERROR_TOOLTIP = "<form><p><span font=\"header\">{0}:</span></p><BR/><li style=\"text\" bindent=\"5\" indent=\"5\">The extension is non functional<BR/><BR/>PHP reports:<BR/>{1}</li></form>";
    private static final String VALIDATION_WARNING_TOOLTIP = "<form><p><span font=\"header\">{0}:</span></p><BR/><li style=\"text\" bindent=\"5\" indent=\"5\">The extension is functional but with a warning<BR/><BR/>PHP reports:<BR/>{1}</li></form>";
    private static final String VALIDATION_UNKNOWN_TOOLTIP = "<form><p><span font=\"header\">{0}:</span></p><BR/><li style=\"text\" bindent=\"5\" indent=\"5\">The extension state is unknown.<br/><br/>Please click the 'Validate Extensions' button to resolve its state</li></form>";
    private static final int ENTRY_NAME_INDEX = 0;
    private static final int ENTRY_VALUE_INDEX = 1;
    private static final int ENTRY_VALID_INDEX = 2;
    private static final Image TREE_ICON = SWTUtils.getImage((AbstractUIPlugin)PHPEplPlugin.getDefault(), (String)"/icons/full/obj16/tree_mode.gif");
    private static final Image VALIDATION_OK_ICON = SWTUtils.getImage((AbstractUIPlugin)PHPEplPlugin.getDefault(), (String)"/icons/full/obj16/validation_ok.gif");
    private static final Image VALIDATION_ERROR_ICON = SWTUtils.getImage((AbstractUIPlugin)PHPEplPlugin.getDefault(), (String)"/icons/full/obj16/validation_err.gif");
    private static final Image VALIDATION_WARNING_ICON = SWTUtils.getImage((AbstractUIPlugin)PHPEplPlugin.getDefault(), (String)"/icons/full/obj16/validation_warn.gif");
    private static final Image VALIDATION_UNKNOWN_ICON = SWTUtils.getImage((AbstractUIPlugin)PHPEplPlugin.getDefault(), (String)"/icons/full/obj16/validation_unknown.gif");
    private static final RGB COMMENT_FOREGROUND_RGB = new RGB(0, 128, 0);
    private static final RGB SECTION_BACKGROUND_RGB = new RGB(203, 243, 243);
    private final Color COMMENT_FOREGROUND = new Color((Device)Display.getCurrent(), COMMENT_FOREGROUND_RGB);
    private final Color SECTION_BACKGROUND = new Color((Device)Display.getCurrent(), SECTION_BACKGROUND_RGB);
    private final Font COMMENT_FONT;
    private static final String NAME_PROPERTY = Messages.PHPIniEditor_3;
    private static final String VALUE_PROPERTY = Messages.PHPIniEditor_4;
    private TreeViewer viewer;
    private PHPIniContentProvider provider;
    private Button addEntryButton;
    private Button removeButton;
    private Composite mainComposite;
    private boolean isEnabled;
    private Button addSectionButton;
    private Button commentButton;
    private Button validateButton;
    private String phpExePath;
    private boolean isShowingExtensionsOnly;
    private ViewerFilter extensionsOnlyFilter;
    private String debuggerID;

    private Image getEntryValidationColumnImage(PHPIniEntry entry) {
        if (entry.isExtensionEntry()) {
            switch (entry.getValidationState()) {
                case OK: {
                    return VALIDATION_OK_ICON;
                }
                case ERROR: {
                    return VALIDATION_ERROR_ICON;
                }
                case WARNING: {
                    return VALIDATION_WARNING_ICON;
                }
            }
            return VALIDATION_UNKNOWN_ICON;
        }
        return null;
    }

    public PHPIniEditor() {
        Font defaultFont = JFaceResources.getDefaultFont();
        FontData data = new FontData(defaultFont.getFontData()[0].getName(), defaultFont.getFontData()[0].getHeight(), 2);
        this.COMMENT_FONT = new Font((Device)Display.getDefault(), data);
        this.extensionsOnlyFilter = new ExtensionsOnlyFilter();
    }

    public void setPHPExe(String path) {
        this.phpExePath = path;
    }

    public void setDebuggerID(String debuggerID) {
        this.debuggerID = debuggerID;
    }

    public void openFile(String fileName) throws IOException {
        this.provider = new PHPIniContentProvider(fileName);
        this.viewer.setContentProvider((IContentProvider)this.provider);
        this.viewer.setInput(new Object());
        this.viewer.refresh();
        this.viewer.getTree().getParent().layout(true, true);
        this.enable();
        this.modifyButtonsStates();
    }

    public void save() throws IOException {
        if (this.isEnabled() && this.provider != null) {
            this.provider.save();
        }
    }

    public String getFileName() {
        if (this.provider != null) {
            return this.provider.getFileName();
        }
        return null;
    }

    public void showExtensionsOnly(boolean show) {
        if (this.isShowingExtensionsOnly != show) {
            this.isShowingExtensionsOnly = show;
            if (this.viewer != null) {
                if (this.isShowingExtensionsOnly) {
                    this.viewer.addFilter(this.extensionsOnlyFilter);
                    this.viewer.expandAll();
                } else {
                    this.viewer.removeFilter(this.extensionsOnlyFilter);
                }
            }
        }
    }

    public Control createControl(Composite parent) {
        this.mainComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        this.mainComposite.setLayout((Layout)layout);
        this.mainComposite.setLayoutData((Object)new GridData(1808));
        Control buttonsContainer = this.createButtonsBar(this.mainComposite);
        GridData buttonsContainerData = new GridData(768);
        buttonsContainer.setLayoutData((Object)buttonsContainerData);
        final Button onlyExtensionsCheck = new Button(this.mainComposite, 32);
        onlyExtensionsCheck.setText(Messages.PHPIniEditor_showExtensionOnlyButton);
        GridData layoutData = new GridData(768);
        layoutData.horizontalIndent = 5;
        onlyExtensionsCheck.setLayoutData((Object)layoutData);
        onlyExtensionsCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PHPIniEditor.this.showExtensionsOnly(onlyExtensionsCheck.getSelection());
            }
        });
        Control viewerContainer = this.createViewer(this.mainComposite);
        GridData viewerContainerData = new GridData(1808);
        viewerContainerData.grabExcessHorizontalSpace = true;
        viewerContainerData.grabExcessVerticalSpace = true;
        viewerContainer.setLayoutData((Object)viewerContainerData);
        this.modifyButtonsStates();
        this.disable();
        return this.mainComposite;
    }

    private Control createViewer(Composite parent) {
        Composite viewerContainer = new Composite(parent, 0);
        viewerContainer.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(viewerContainer, 67584);
        this.viewer.setColumnProperties(new String[]{NAME_PROPERTY, VALUE_PROPERTY});
        this.viewer.setLabelProvider((IBaseLabelProvider)new PHPIniLabelProvider());
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.setUseHashlookup(true);
        TreeColumn nameColumn = new TreeColumn(this.viewer.getTree(), 0);
        nameColumn.setText(Messages.PHPIniEditor_5);
        TreeColumn valueColumn = new TreeColumn(this.viewer.getTree(), 0);
        valueColumn.setText(Messages.PHPIniEditor_6);
        TreeColumn validityColumn = new TreeColumn(this.viewer.getTree(), 0);
        validityColumn.setText(Messages.PHPIniEditor_21);
        TableLayout columnLayout = new TableLayout();
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
        TextCellEditor valueEditor = new TextCellEditor((Composite)this.viewer.getTree());
        CellEditor[] cellEditorArray = new CellEditor[3];
        cellEditorArray[1] = valueEditor;
        this.viewer.setCellEditors(cellEditorArray);
        this.viewer.setCellModifier((ICellModifier)new PHPIniCellModifier());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PHPIniEditor.this.modifyButtonsStates();
            }
        });
        this.viewer.getTree().addControlListener(new ControlListener(){
            int times;

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                ++this.times;
                if (this.times <= 2) {
                    TableLayout columnLayout = new TableLayout();
                    columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40));
                    columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
                    columnLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
                    PHPIniEditor.this.viewer.getTree().setLayout((Layout)columnLayout);
                    PHPIniEditor.this.viewer.getTree().layout(true);
                }
            }
        });
        if (this.isShowingExtensionsOnly) {
            this.viewer.addFilter(this.extensionsOnlyFilter);
        }
        this.viewer.getTree().setLayout((Layout)columnLayout);
        this.viewer.getTree().getParent().layout(true, true);
        new PHPExtensionsTooltip((Control)this.viewer.getTree());
        return viewerContainer;
    }

    private String getEntryTooltipInfo(PHPIniEntry entry) {
        switch (entry.getValidationState()) {
            case OK: {
                return MessageFormat.format(VALIDATION_OK_TOOLTIP, entry.getValue());
            }
            case ERROR: {
                return MessageFormat.format(VALIDATION_ERROR_TOOLTIP, entry.getValue(), entry.getValidationNote());
            }
            case WARNING: {
                return MessageFormat.format(VALIDATION_WARNING_TOOLTIP, entry.getValue(), entry.getValidationNote());
            }
        }
        return MessageFormat.format(VALIDATION_UNKNOWN_TOOLTIP, entry.getValue());
    }

    private Control createButtonsBar(Composite mainComposite) {
        Composite buttonsComposite = new Composite(mainComposite, 0);
        buttonsComposite.setLayout((Layout)new GridLayout(5, true));
        this.addEntryButton = new Button(buttonsComposite, 0);
        this.addEntryButton.setText(Messages.PHPIniEditor_Entry);
        this.addEntryButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addEntryButton.setToolTipText(Messages.PHPIniEditor_7);
        this.addEntryButton.setImage(SWTUtils.getImage((AbstractUIPlugin)UIPlugin.getDefault(), (String)ADD_ICON));
        this.addEntryButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PHPIniEditor.this.addEntry();
            }
        });
        this.removeButton = new Button(buttonsComposite, 0);
        this.removeButton.setText(Messages.PHPIniEditor_Delete);
        this.removeButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.removeButton.setToolTipText(Messages.PHPIniEditor_8);
        this.removeButton.setImage(SWTUtils.getImage((AbstractUIPlugin)UIPlugin.getDefault(), (String)DELETE_ICON));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PHPIniEditor.this.removeEntry();
            }
        });
        this.addSectionButton = new Button(buttonsComposite, 0);
        this.addSectionButton.setText(Messages.PHPIniEditor_Section);
        this.addSectionButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.addSectionButton.setToolTipText(Messages.PHPIniEditor_9);
        this.addSectionButton.setImage(SWTUtils.getImage((AbstractUIPlugin)PHPEplPlugin.getDefault(), (String)ADD_SECTION_ICON_PATH));
        this.addSectionButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PHPIniEditor.this.addSection();
            }
        });
        this.commentButton = new Button(buttonsComposite, 0);
        this.commentButton.setText(Messages.PHPIniEditor_Comment);
        this.commentButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.commentButton.setToolTipText(Messages.PHPIniEditor_10);
        this.commentButton.setImage(COMMENT_ICON);
        this.commentButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PHPIniEditor.this.comment();
            }
        });
        this.validateButton = new Button(buttonsComposite, 0);
        this.validateButton.setText(Messages.PHPIniEditor_Validate);
        this.validateButton.setLayoutData((Object)new GridData(4, 4, false, false));
        this.validateButton.setToolTipText(Messages.PHPIniEditor_22);
        this.validateButton.setImage(VALIDATE_ICON);
        this.validateButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                PHPIniEditor.this.validateExtensions();
            }
        });
        return buttonsComposite;
    }

    public void dispose() {
        if (this.provider != null) {
            this.provider.dispose();
        }
        if (this.COMMENT_FOREGROUND != null) {
            this.COMMENT_FOREGROUND.dispose();
        }
        if (this.SECTION_BACKGROUND != null) {
            this.SECTION_BACKGROUND.dispose();
        }
        if (this.COMMENT_FONT != null) {
            this.COMMENT_FONT.dispose();
        }
    }

    public void modifyEntry(PHPIniEntry entry, String value) {
        if (this.provider != null) {
            this.provider.modifyEntry(entry, value);
        }
    }

    public void enable() {
        if (this.mainComposite != null && this.provider != null) {
            this.isEnabled = true;
            this.enableAll((Control)this.mainComposite);
        }
    }

    public void disable() {
        if (this.mainComposite != null) {
            this.isEnabled = false;
            this.disableAll((Control)this.mainComposite);
        }
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private void addEntry() {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            INIFileSection section = null;
            if (element instanceof PHPIniEntry || element instanceof INIFileSection) {
                NewPHPIniEntryDialog dialog = new NewPHPIniEntryDialog(this.viewer.getTree().getShell());
                if (dialog.open() == 0) {
                    String name = dialog.getName();
                    String value = dialog.getValue();
                    if (element instanceof INIFileSection) {
                        section = (INIFileSection)element;
                        this.provider.insertEntryToSectionBeginning(section, name, value);
                        this.viewer.reveal((Object)section);
                        this.viewer.expandToLevel((Object)section, 1);
                    } else if (element instanceof PHPIniEntry) {
                        this.provider.insertEntry((PHPIniEntry)element, name, value);
                    }
                    this.viewer.refresh(true);
                    this.viewer.getTree().getParent().layout(true, true);
                }
            } else {
                NewPHPIniEntryDialog dialog = new NewPHPIniEntryDialog(this.viewer.getTree().getShell());
                if (dialog.open() == 0) {
                    String name = dialog.getName();
                    String value = dialog.getValue();
                    section = this.provider.getGlobalSection();
                    this.provider.insertEntryToSectionBeginning(section, name, value);
                    this.viewer.reveal((Object)section);
                    this.viewer.refresh(true);
                    this.viewer.expandToLevel((Object)section, 1);
                    this.viewer.getTree().getParent().layout(true, true);
                }
            }
        }
    }

    private void addSection() {
        NewPHPIniSectionDialog dialog = new NewPHPIniSectionDialog(this.viewer.getTree().getShell());
        ArrayList<String> sectionsNames = new ArrayList<String>();
        for (INIFileSection section : this.provider.getSections()) {
            sectionsNames.add(section.getName());
        }
        dialog.setForbiddenNames(sectionsNames);
        if (dialog.open() == 0) {
            String name = dialog.getName();
            INIFileSection section = this.provider.addSection(name);
            this.viewer.refresh(true);
            this.viewer.reveal((Object)section);
            this.viewer.getTree().getParent().layout(true, true);
        }
    }

    private void removeEntry() {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof PHPIniEntry) {
                this.provider.removeEntry((PHPIniEntry)element);
                this.viewer.refresh(true);
                this.viewer.getTree().getParent().layout(true, true);
            } else if (element instanceof INIFileSection) {
                INIFileSection section = (INIFileSection)element;
                if (section.equals(this.provider.getGlobalSection())) {
                    MessageDialog.openInformation((Shell)this.viewer.getTree().getShell(), (String)Messages.PHPIniEditor_11, (String)Messages.PHPIniEditor_12);
                    return;
                }
                boolean result = MessageDialog.openQuestion((Shell)this.viewer.getTree().getShell(), (String)Messages.PHPIniEditor_13, (String)(String.valueOf(Messages.PHPIniEditor_14) + section.getName() + Messages.PHPIniEditor_15));
                if (result) {
                    this.provider.removeSection(section);
                    this.viewer.refresh(true);
                    this.viewer.getTree().getParent().layout(true, true);
                }
            }
        }
    }

    private void comment() {
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof PHPIniEntry) {
                PHPIniEntry entry = (PHPIniEntry)element;
                if (entry.getCommented()) {
                    this.provider.uncommentEntry(entry);
                } else {
                    this.provider.commentEntry(entry);
                }
                this.viewer.refresh(true);
                this.viewer.reveal((Object)entry);
                this.viewer.getTree().getParent().layout(true, true);
            } else if (element instanceof INIFileSection) {
                INIFileSection section = (INIFileSection)element;
                if (this.allEntriesAreCommented(section)) {
                    for (PHPIniEntry entry : section.getEntries()) {
                        this.provider.uncommentEntry(entry);
                    }
                } else if (this.allEntriesAreUnCommented(section)) {
                    for (PHPIniEntry entry : section.getEntries()) {
                        this.provider.commentEntry(entry);
                    }
                }
                this.viewer.refresh(true);
                this.viewer.expandToLevel((Object)section, 1);
                this.viewer.getTree().getParent().layout(true, true);
            }
        }
    }

    public boolean validateExtensions() {
        if (this.provider == null) {
            return false;
        }
        if (this.provider.isDirtyINI()) {
            if (!MessageDialog.openQuestion((Shell)this.viewer.getTree().getShell(), (String)Messages.PHPIniEditor_extensionValidatorTitle, (String)Messages.PHPIniEditor_extensionValidatorQuestion)) {
                return false;
            }
            try {
                this.provider.save();
            }
            catch (IOException e) {
                MessageDialog.openError((Shell)this.viewer.getTree().getShell(), (String)Messages.PHPIniEditor_errorTitle, (String)Messages.PHPIniEditor_errorSavingIniMessage);
                IdeLog.logError((Plugin)PHPDebugPlugin.getDefault(), (String)"Error saving the php.ini", (Throwable)e, (String)"com.aptana.php.debug/debug");
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                PHPIniEditor.this.viewer.expandAll();
            }
        });
        new PHPIniValidator(this.provider, this.phpExePath, this.debuggerID).validate();
        this.viewer.refresh(true);
        this.viewer.getTree().getParent().layout(true, true);
        return true;
    }

    private void disableAll(Control control) {
        Object[] children;
        if (control instanceof Composite && !ArrayUtil.isEmpty((Object[])(children = ((Composite)control).getChildren()))) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.disableAll((Control)child);
                ++n2;
            }
        }
        control.setEnabled(false);
    }

    private void enableAll(Control control) {
        Object[] children;
        if (control instanceof Composite && !ArrayUtil.isEmpty((Object[])(children = ((Composite)control).getChildren()))) {
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.enableAll((Control)child);
                ++n2;
            }
        }
        control.setEnabled(true);
    }

    private void modifyButtonsStates() {
        Object element;
        this.addEntryButton.setEnabled(true);
        this.addSectionButton.setEnabled(true);
        ISelection selection = this.viewer.getSelection();
        if (selection != null && selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) != null) {
            this.removeButton.setEnabled(true);
            if (element instanceof PHPIniEntry) {
                if (((PHPIniEntry)element).getCommented()) {
                    this.commentButton.setImage(UNCOMMENT_ICON);
                    this.commentButton.setToolTipText(Messages.PHPIniEditor_16);
                } else {
                    this.commentButton.setImage(COMMENT_ICON);
                    this.commentButton.setToolTipText(Messages.PHPIniEditor_17);
                }
                this.commentButton.setEnabled(true);
            } else if (element instanceof INIFileSection) {
                INIFileSection section = (INIFileSection)element;
                if (this.allEntriesAreCommented(section)) {
                    this.commentButton.setImage(UNCOMMENT_ICON);
                    this.commentButton.setToolTipText(Messages.PHPIniEditor_18);
                    this.commentButton.setEnabled(true);
                } else if (this.allEntriesAreUnCommented(section)) {
                    this.commentButton.setImage(COMMENT_ICON);
                    this.commentButton.setToolTipText(Messages.PHPIniEditor_19);
                    this.commentButton.setEnabled(true);
                }
            }
            return;
        }
        this.removeButton.setEnabled(false);
        this.commentButton.setEnabled(false);
    }

    private boolean allEntriesAreCommented(INIFileSection section) {
        if (section.getEntries().size() == 0) {
            return false;
        }
        for (PHPIniEntry entry : section.getEntries()) {
            if (entry.getCommented()) continue;
            return false;
        }
        return true;
    }

    private boolean allEntriesAreUnCommented(INIFileSection section) {
        if (section.getEntries().size() == 0) {
            return false;
        }
        for (PHPIniEntry entry : section.getEntries()) {
            if (!entry.getCommented()) continue;
            return false;
        }
        return true;
    }

    private static class ExtensionsOnlyFilter
    extends ViewerFilter {
        private static final Set<String> EXTENSION_DATA_KEYS = CollectionsUtil.newSet((Object[])new String[]{"extension", "extension_dir", "zend_extension", "zend_extension_ts"});

        private ExtensionsOnlyFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof INIFileSection) {
                return this.containsExtensionData((INIFileSection)element);
            }
            if (element instanceof PHPIniEntry) {
                return this.containsExtensionData((PHPIniEntry)element);
            }
            return false;
        }

        private boolean containsExtensionData(PHPIniEntry entry) {
            return EXTENSION_DATA_KEYS.contains(entry.getKey());
        }

        private boolean containsExtensionData(INIFileSection section) {
            List<PHPIniEntry> entries = section.getEntries();
            for (PHPIniEntry entry : entries) {
                if (!this.containsExtensionData(entry)) continue;
                return true;
            }
            return false;
        }
    }

    private class PHPExtensionsTooltip
    extends ToolTip {
        PHPExtensionsTooltip(Control control) {
            super(control);
        }

        protected boolean shouldCreateToolTip(Event event) {
            if (super.shouldCreateToolTip(event)) {
                TreeItem treeItem = PHPIniEditor.this.viewer.getTree().getItem(new Point(event.x, event.y));
                return treeItem != null && treeItem.getData() instanceof PHPIniEntry && ((PHPIniEntry)treeItem.getData()).isExtensionEntry();
            }
            return false;
        }

        protected Composite createToolTipContentArea(Event event, Composite parent) {
            TreeItem treeItem = PHPIniEditor.this.viewer.getTree().getItem(new Point(event.x, event.y));
            PHPIniEntry entry = (PHPIniEntry)treeItem.getData();
            if (!entry.isExtensionEntry()) {
                return null;
            }
            Composite sm = new Composite(parent, 0);
            sm.setLayout((Layout)GridLayoutFactory.fillDefaults().margins(10, 10).create());
            FormText ts = new FormText(sm, 0);
            ts.setWhitespaceNormalized(true);
            ts.setFont("header", JFaceResources.getHeaderFont());
            ts.setText(PHPIniEditor.this.getEntryTooltipInfo(entry), true, false);
            Point size = sm.computeSize(-1, -1);
            if (size != null && size.x > 0 && size.y > 0) {
                ts.setLayoutData((Object)new GridData(Math.min(500, size.x), size.y + 5));
            } else {
                ts.setLayoutData((Object)new GridData(200, 40));
            }
            return sm;
        }
    }

    class PHPIniCellModifier
    implements ICellModifier {
        PHPIniCellModifier() {
        }

        public boolean canModify(Object element, String property) {
            PHPIniEntry entry;
            return element != null && element instanceof PHPIniEntry && VALUE_PROPERTY.equals(property) && !(entry = (PHPIniEntry)element).getCommented();
        }

        public Object getValue(Object element, String property) {
            PHPIniEntry entry;
            if (element != null && element instanceof PHPIniEntry && VALUE_PROPERTY.equals(property) && !(entry = (PHPIniEntry)element).getCommented()) {
                return entry.getValue();
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            PHPIniEntry entry;
            if (element != null && element instanceof TreeItem && ((TreeItem)element).getData() != null && ((TreeItem)element).getData() instanceof PHPIniEntry && VALUE_PROPERTY.equals(property) && !(entry = (PHPIniEntry)((TreeItem)element).getData()).getCommented() && !value.equals(entry.getValue())) {
                PHPIniEditor.this.modifyEntry(entry, value.toString());
                if (PHPIniEditor.this.viewer != null) {
                    PHPIniEditor.this.viewer.refresh(true);
                    PHPIniEditor.this.viewer.getTree().getParent().layout(true, true);
                }
            }
        }
    }

    class PHPIniLabelProvider
    implements ITableLabelProvider,
    IColorProvider,
    IFontProvider {
        PHPIniLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0 && element instanceof INIFileSection) {
                return TREE_ICON;
            }
            if (columnIndex == 2 && element instanceof PHPIniEntry) {
                return PHPIniEditor.this.getEntryValidationColumnImage((PHPIniEntry)element);
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof PHPIniEntry) {
                PHPIniEntry entry = (PHPIniEntry)element;
                if (columnIndex == 0) {
                    return entry.getKey();
                }
                if (columnIndex == 1) {
                    return entry.getValue();
                }
            } else if (element instanceof INIFileSection && columnIndex == 0) {
                return ((INIFileSection)element).getName();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (element instanceof PHPIniEntry && ((PHPIniEntry)element).getCommented()) {
                return PHPIniEditor.this.COMMENT_FOREGROUND;
            }
            return null;
        }

        public Font getFont(Object element) {
            if (element instanceof PHPIniEntry && ((PHPIniEntry)element).getCommented()) {
                return PHPIniEditor.this.COMMENT_FONT;
            }
            return null;
        }
    }
}

